<!DOCTYPE html>
<html lang="en">

<head>
    <title>بیمه توانا</title>
    <meta charset="UTF-8">
    <meta name="description" content="Cryptoplus Landing Page Template">
    <meta name="keywords" content="cryptoplus, crypto, creative, html, landing_page">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- Favicon -->
    <link href="crypto/favicon.ico" rel="shortcut icon"/>

    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css?family=Lato" rel="stylesheet">

    <!-- Stylesheets -->
    <link rel="stylesheet" href="css/bootstrap.min.css"/>
    <link rel="stylesheet" href="css/font-awesome.min.css"/>
    <link rel="stylesheet" href="css/fontiran.css"/>
    <link rel="stylesheet" href="css/themify-icons.css"/>
    <link rel="stylesheet" href="css/animate.css"/>
    <link rel="stylesheet" href="css/owl.carousel.css"/>
    <link rel="stylesheet" href="css/style.css"/>
    <script src="js/jquery-3.2.1.min.js"></script>
    <script src="js/sweetalert2.all.min.js"></script>
    <link rel="stylesheet" href="css/sweetalert2.min.css">
    <style>

        .main-container {
            display: flex;
            width: 80%;
            height: 80%;
        }

        .image-container {
            flex: 1;
            display: flex;
            justify-content: center;
            align-items: center;
            padding: 20px;
        }

        .image-container img {
            max-width: 100%;
            max-height: 100%;
        }

        .buttons-container {
            flex: 1;
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 10px;
            padding: 20px;
        }

        .box {
            background-color: #f0f0f0;
            border-radius: 10px;
            padding: 20px;
            text-align: center;
            width: 120px;
            height: 120px;
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
        }

        .box i {
            font-size: 30px;
            color: #333;
        }

        .box p {
            margin-top: 10px;
            font-size: 14px;
        }

        @media (max-width: 768px) {
            .main-container {
                flex-direction: column;
                align-items: center;
            }

            .buttons-container {
                grid-template-columns: repeat(2, 1fr);
                margin-right: 0;
            }
        }


    </style>



</head>

<body>
<!-- Page Preloder -->
<div id="preloder">
    <div class="loader"></div>
</div>

<!-- Header section -->
<?php

include 'include/header.php';

?>
<!-- Header section end -->


<!-- Hero section -->
<section class="hero-section">
    <div class="container">
        <div class="row">
            <div class="col-md-6 hero-text">
                <h2>خرید بیمه با <span> توانا</span> </h2>


                <div class="main-container">

                    <div class="buttons-container">
                        <a href="third_party_insurance.php">


                        <div class="box">
                            <img src="images/service/third-party.png" width="60" height="60">  <!-- icon for شخص ثالث -->
                            <p>شخص ثالث</p>

                        </div>

                        </a>

                        <a href="body_insurance_car.php">
                        <div class="box">
                            <img src="images/service/body.png" width="60" height="60">
                            <p>بدنه</p>

                        </div>
                        </a>
                        <div class="box">
                            <img src="images/service/fire.png" width="60" height="60">
                            <p>آتش سوزی</p>
                        </div>
                        <div class="box">
                            <img src="images/service/health.png" width="60" height="60">
                            <p>درمان مسافراتی</p>
                        </div>
                        <div class="box">
                            <img src="images/service/complementary_treatment.png" width="60" height="60">
                            <p>درمان تکمیلی</p>

                        </div>
                        <div class="box">
                            <img src="images/service/individual_incidents.png" width="60" height="60">
                            <p>حوادث انفرادی</p>
                        </div>
                        <div class="box">
                            <img src="images/service/responsibility.png" width="60" height="60">
                            <p>مسئولیت</p>
                        </div>
                        <div class="box">
                            <img src="images/service/enginnering.png" width="60" height="60">
                            <p>مهندسی</p>
                        </div>
                        <div class="box">
                            <img src="images/service/company_customers.png" width="50" height="50">
                            <p>مشتریان سازمانی</p>
                        </div>
                    </div>



                </div>

            </div>
            <div class="col-md-6">
                <img src="images/laptop.png" class="laptop-image" alt="">
            </div>
        </div>
    </div>
</section>
<!-- Hero section end -->


<!-- About section -->
<section class="about-section spad">
    <div class="container">
        <div class="row">
            <div class="col-lg-6 offset-lg-6 about-text">
                <h2>چرا از توانا بخرم؟</h2>
                <h5>چون ما در توانا بهت کمک می‌کنیم، مناسب‌ترین بیمه رو انتخاب کنی.</h5>
                <p>مقایسه قیمت و خدمات بیمه‌ها</p>
                <p>خرید بیمه؛ هر زمان و هر کجا</p>
                <p>امکان خرید قسطی بیمه</p>
                <p>تحت نظارت بیمه مرکزی</p>
                <p>صدور سریع بیمه‌نامه</p>
                <p></p>
                <a href="about.php" class="site-btn sb-gradients sbg-line mt-5">ادامه مطلب</a>
            </div>
            <div class="about-img">
                <img src="images/about-img.png" alt="">
            </div>
        </div>

    </div>
</section>
<!-- About section end -->


<!-- Features section -->
<section class="features-section spad gradient-bg" id="featuresection">
    <div class="container text-white">
        <div class="section-title text-center">
            <h2>ویژگی‌های ما</h2>
            <p>بیت کوین ارز دیجیتال غیرمتمرکزی است که توسط مردم کنترل می‌شود.</p>
        </div>
        <div class="row">
            <!-- feature -->
            <div class="col-md-6 col-lg-4 feature">
                <i class="ti-mobile"></i>
                <div class="feature-content">
                    <h4>اپلیکیشن‌های موبایل</h4>
                    <p>لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.
                    </p>
                    <a href="" class="readmore">ادامه مطلب</a>
                </div>
            </div>
            <!-- feature -->
            <div class="col-md-6 col-lg-4 feature">
                <i class="ti-shield"></i>
                <div class="feature-content">
                    <h4>امنیت 100%</h4>
                    <p>لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.
                    </p>
                    <a href="" class="readmore">ادامه مطلب</a>
                </div>
            </div>
            <!-- feature -->
            <div class="col-md-6 col-lg-4 feature">
                <i class="ti-wallet"></i>
                <div class="feature-content">
                    <h4>کیف پول</h4>
                    <p>لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.
                    </p>
                    <a href="" class="readmore">ادامه مطلب</a>
                </div>
            </div>
            <!-- feature -->
            <div class="col-md-6 col-lg-4 feature">
                <i class="ti-headphone-alt"></i>
                <div class="feature-content">
                    <h4>پشتیبانی دائمی</h4>
                    <p>لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.
                    </p>
                    <a href="" class="readmore">ادامه مطلب</a>
                </div>
            </div>
            <!-- feature -->
            <div class="col-md-6 col-lg-4 feature">
                <i class="ti-reload"></i>
                <div class="feature-content">
                    <h4>تبدیل ارز فوری</h4>
                    <p>لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.
                    </p>
                    <a href="" class="readmore">ادامه مطلب</a>
                </div>
            </div>
            <!-- feature -->
            <div class="col-md-6 col-lg-4 feature">
                <i class="ti-panel"></i>
                <div class="feature-content">
                    <h4>خریدهای مکرر</h4>
                    <p>لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.
                    </p>
                    <a href="" class="readmore">ادامه مطلب</a>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Features section end -->


<!-- Process section -->
<section class="process-section spad">
    <div class="container">
        <div class="section-title text-center">
            <h2>چطوری بیمه بخرم</h2>
            <p>برای خرید بیمه از توانا می توانید در چهار مرحله اینکار را انجام دهید</p>
        </div>
        <div class="row">
            <div class="col-md-3 process">
                <div class="process-step">
                    <figure class="process-icon">
                        <img src="images/process-icons/1.png" alt="#">
                    </figure>
                    <h4>انتخاب بیمه مورد نظر</h4>
                    <p>وارد فرم استعلام بیمه نامه مدنظر خود شده و اطلاعات و جزییات درخواستی را در کادرهای مربوط به صورت صحیح جهت حصول بهترین نتیجه تکمیل نمایید.
                    </p>
                </div>
            </div>
            <div class="col-md-3 process">
                <div class="process-step">
                    <figure class="process-icon">
                        <img src="images/process-icons/2.png" alt="#">
                    </figure>
                    <h4>تکمیل اطلاعات</h4>
                    <p>با کلیک کردن روی دکمه استعلام،سامانه فهرستی از شرکت های بیمه کننده و شرایط مربوط را جهت انتخاب متناسب با نیاز بیمه ای شما،نمایش خواهد داد</p>
                </div>
            </div>
            <div class="col-md-3 process">
                <div class="process-step">
                    <figure class="process-icon">
                        <img src="images/process-icons/3.png" alt="#">
                    </figure>
                    <h4>پرداخت حق بیمه</h4>
                    <p>اطلاعات هویتی و جزییات بیمه نامه درخواستی را وارد نمایید.در صفحه پرداخت وجه بیمه نامه،مشخصات بیمه و پوشش های بیمه ای دیده شوند.</p>
                </div>
            </div>


            <div class="col-md-3 process">
                <div class="process-step">
                    <figure class="process-icon">
                        <img src="images/process-icons/3.png" alt="#">
                    </figure>
                    <h4>ارسال بیمه</h4>
                    <p>دریافت کد رهگیری به منزله پایان فرایند خرید بیمه نامه است.بیمه نامه شما در اسرع وقت به محل معین و مطلوب شما بدون هیچ هزینه ای ارسال خواهد شد.
                    </p>
                </div>
            </div>

        </div>
    </div>
</section>
<!-- Process section end -->


<!-- Fact section -->
<section class="fact-section gradient-bg">
    <div class="container">
        <div class="row">
            <div class="col-sm-6 col-md-6 col-lg-3">
                <div class="fact">
                    <i class="ti-basketball"></i>
                    <h2>60+<span>تماس</span></h2>
                    <p>پشتیبانی کشورها</p>

                </div>
            </div>
            <div class="col-sm-6 col-md-6 col-lg-3">
                <div class="fact">
                    <i class="ti-panel"></i>
                    <h2>12+<span>هزار</span></h2>
                    <p>تراکنش‌ در هر ساعت</p>
                </div>
            </div>
            <div class="col-sm-6 col-md-6 col-lg-3">
                <div class="fact">
                    <i class="ti-stats-up"></i>
                    <h2>5<span>میلیارد</span></h2>
                    <p>بیشترین تراکنش‌ها</p>
                </div>
            </div>
            <div class="col-sm-6 col-md-6 col-lg-3">
                <div class="fact">
                    <i class="ti-user"></i>
                    <h2>211<span>پروژه</span></h2>
                    <p>میزان تجربه ما</p>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Fact section end -->


<!-- Team section -->
<section class="team-section spad">
    <div class="container">
        <div class="section-title text-center">
            <h2>متخصصان تیم ما</h2>
            <p>متخصصان و کارشناسان ما آماده‌اند تا با روی باز به سوالات مربوط به ارزهای دیجیتال شما پاسخ دهند.</p>
        </div>
    </div>
    <div class="team-members clearfix">
        <!-- Team member -->
        <div class="member">
            <div class="member-text">
                <div class="member-img set-bg" data-setbg="images/member/4.jpg"></div>
                <h2>صابر افشاری</h2>
                <span>متخصص رمز ارزها</span>
            </div>
            <div class="member-social">
                <a href=""><i class="fa fa-facebook"></i></a>
                <a href=""><i class="fa fa-linkedin"></i></a>
                <a href=""><i class="fa fa-twitter"></i></a>
                <a href=""><i class="fa fa-paper-plane"></i></a>
                <a href=""><i class="fa fa-instagram"></i></a>

            </div>
            <div class="member-info">
                <div class="member-img mf set-bg" data-setbg="images/member/4.jpg"></div>
                <div class="member-meta">
                    <h2>صابر افشاری</h2>
                    <span>تحلیلگر فاندامنتال</span>
                </div>
                <p>لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.
                    چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است </p>
            </div>
        </div>
        <!-- Team member -->
        <div class="member">
            <div class="member-text">
                <div class="member-img set-bg" data-setbg="images/member/4.jpg"></div>
                <h2>صابر افشاری</h2>
                <span>متخصص رمز ارزها</span>
            </div>
            <div class="member-social">
                <a href=""><i class="fa fa-facebook"></i></a>
                <a href=""><i class="fa fa-linkedin"></i></a>
                <a href=""><i class="fa fa-twitter"></i></a>
                <a href=""><i class="fa fa-paper-plane"></i></a>
                <a href=""><i class="fa fa-instagram"></i></a>
            </div>
            <div class="member-info">
                <div class="member-img mf set-bg" data-setbg="images/member/4.jpg"></div>
                <div class="member-meta">
                    <h2>صابر افشاری</h2>
                    <span>تحلیلگر فاندامنتال</span>
                </div>
                <p>لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.
                    چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است </p>
            </div>
        </div>
        <!-- Team member -->
        <div class="member">
            <div class="member-text">
                <div class="member-img set-bg" data-setbg="images/member/4.jpg"></div>
                <h2>صابر افشاری</h2>
                <span>متخصص رمز ارزها</span>
            </div>
            <div class="member-social">
                <a href=""><i class="fa fa-facebook"></i></a>
                <a href=""><i class="fa fa-linkedin"></i></a>
                <a href=""><i class="fa fa-twitter"></i></a>
                <a href=""><i class="fa fa-paper-plane"></i></a>
                <a href=""><i class="fa fa-instagram"></i></a>
            </div>
            <div class="member-info">
                <div class="member-img mf set-bg" data-setbg="images/member/4.jpg"></div>
                <div class="member-meta">
                    <h2>صابر افشاری</h2>
                    <span>مدیرعامل و تحلیلگر</span>
                </div>
                <p>لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.
                    چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است </p>
            </div>
        </div>
        <!-- Team member -->
        <div class="member">
            <div class="member-text">
                <div class="member-img set-bg" data-setbg="images/member/4.jpg"></div>
                <h2>صابر افشاری</h2>
                <span>مدیر تبلیغات</span>
            </div>
            <div class="member-social">
                <a href=""><i class="fa fa-facebook"></i></a>
                <a href=""><i class="fa fa-linkedin"></i></a>
                <a href=""><i class="fa fa-twitter"></i></a>
                <a href=""><i class="fa fa-paper-plane"></i></a>
                <a href=""><i class="fa fa-instagram"></i></a>
            </div>
            <div class="member-info">
                <div class="member-img mf set-bg" data-setbg="images/member/4.jpg"></div>
                <div class="member-meta">
                    <h2>صابر افشاری</h2>
                    <span>مدیر تبلیغات</span>
                </div>
                <p>لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.
                    چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است </p>
            </div>
        </div>
        <!-- Team member -->
        <div class="member">
            <div class="member-text">
                <div class="member-img set-bg" data-setbg="images/member/5.jpg"></div>
                <h2>صابر افشاری</h2>
                <span>کارشناس امنیت</span>
            </div>
            <div class="member-social">
                <a href=""><i class="fa fa-facebook"></i></a>
                <a href=""><i class="fa fa-linkedin"></i></a>
                <a href=""><i class="fa fa-twitter"></i></a>
                <a href=""><i class="fa fa-paper-plane"></i></a>
                <a href=""><i class="fa fa-instagram"></i></a>
            </div>
            <div class="member-info">
                <div class="member-img mf set-bg" data-setbg="images/member/5.jpg"></div>
                <div class="member-meta">
                    <h2>صابر افشاری</h2>
                    <span>کارشناس امنیت</span>
                </div>
                <p>لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.
                    چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است </p>
            </div>
        </div>
    </div>
</section>
<!-- Team section -->




<!-- Newsletter section -->
<?php

include 'include/newsletter.php';

?>
<!-- Newsletter section end -->


<!-- Blog section -->
<?php

include 'include/blog_recent.php';

?>
<!-- Blog section end -->


<!-- Footer section -->
<?php
include  'include/footer.php';
?>
<!-- Footer section end -->



<!--====== Javascripts & Jquery ======-->
<script src="js/jquery-3.2.1.min.js"></script>
<script src="js/owl.carousel.min.js"></script>
<script src="js/main.js"></script>
<script src="js/time.js"></script>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11.0.18/dist/sweetalert2.all.min.js"></script>


</body>

</html>