<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Multi-Step Form</title>
    <style>
        .step {
            display: none;
        }
        .step.active {
            display: block;
        }
        .buttons {
            margin-top: 20px;
        }
    </style>
</head>
<body>

<form id="multiStepForm">
    <!-- Step 1 -->
    <div class="step active">
        <h2>Step 1</h2>
        <label for="name">Name:</label>
        <input type="text" id="name" name="name" required>
        <div class="buttons">
            <button type="button" id="next1">Next</button>
        </div>
    </div>

    <!-- Step 2 -->
    <div class="step">
        <h2>Step 2</h2>
        <label for="email">Email:</label>
        <input type="email" id="email" name="email" required>
        <div class="buttons">
            <button type="button" id="back2">Back</button>
            <button type="button" id="next2">Next</button>
        </div>
    </div>

    <!-- Step 3 -->
    <div class="step">
        <h2>Step 3</h2>
        <label for="phone">Phone:</label>
        <input type="tel" id="phone" name="phone" required>
        <div class="buttons">
            <button type="button" id="back3">Back</button>
            <button type="button" id="next3">Next</button>
        </div>
    </div>

    <!-- Step 4 -->
    <div class="step">
        <h2>Step 4</h2>
        <label for="address">Address:</label>
        <input type="text" id="address" name="address" required>
        <div class="buttons">
            <button type="button" id="back4">Back</button>
            <button type="submit">Submit</button>
        </div>
    </div>
</form>

<script>
    const steps = document.querySelectorAll('.step');
    const nextButtons = document.querySelectorAll('[id^=next]');
    const backButtons = document.querySelectorAll('[id^=back]');
    let currentStep = 0;

    nextButtons.forEach(button => {
        button.addEventListener('click', () => {
            if (validateForm()) {
                steps[currentStep].classList.remove('active');
                currentStep++;
                steps[currentStep].classList.add('active');
            }
        });
    });

    backButtons.forEach(button => {
        button.addEventListener('click', () => {
            steps[currentStep].classList.remove('active');
            currentStep--;
            steps[currentStep].classList.add('active');
        });
    });

    function validateForm() {
        const inputs = steps[currentStep].querySelectorAll('input');
        for (let i = 0; i < inputs.length; i++) {
            if (!inputs[i].value) {
                alert('Please fill all fields');
                return false;
            }
        }
        return true;
    }
</script>

</body>
</html>