<!DOCTYPE html>
<html lang="en">

<head>
    <title>کریپتو پلاس</title>
    <meta charset="UTF-8">
    <meta name="description" content="Cryptoplus Landing Page Template">
    <meta name="keywords" content="cryptoplus, crypto, creative, html, landing_page">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- Favicon -->
    <link href="images/favicon.ico" rel="shortcut icon" />

    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css?family=Lato" rel="stylesheet">

    <!-- Stylesheets -->
    <link rel="stylesheet" href="css/bootstrap.min.css" />
    <link rel="stylesheet" href="css/font-awesome.min.css" />
    <link rel="stylesheet" href="css/fontiran.css" />
    <link rel="stylesheet" href="css/themify-icons.css" />
    <link rel="stylesheet" href="css/animate.css" />
    <link rel="stylesheet" href="css/owl.carousel.css" />
    <link rel="stylesheet" href="css/style.css" />


    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->

</head>

<body>
<!-- Page Preloder -->
<div id="preloder">
    <div class="loader"></div>
</div>

<!-- Header section -->
<?php

include 'include/header.php';

?>
<!-- Header section end -->


<!-- Page info section -->
<section class="page-info-section">
    <div class="container">
        <h2>درباره ما</h2>
        <div class="site-beradcamb">
            <a href="">صفحه نخست</a>
            <span><i class="fa fa-angle-right"></i> درباره ما</span>
        </div>
    </div>
</section>
<!-- Page info end -->


<!-- About section -->
<section class="about-section spad">
    <div class="container">
        <div class="row">
            <div class="col-lg-6 offset-lg-6 about-text">
                <h2>بیت کوین چیست؟</h2>
                <h5>بیت کوین نوعی ارزدیجیتال است که می‌توانید با آن خرید کنید.</h5>
                <p>بیت کوین نوعی ارزدیجیتال است که می‌توانید با آن خرید کنید، سفارش‌ آنلاین انجام دهید، به هر کسی که
                    دوست دارید در هر نقطه از جهان پول بفرستید یا حتی آن را به عنوان نوعی سرمایه‌گذاری در نظر بگیرید.
                </p>
                <a href="" class="site-btn sb-gradients sbg-line mt-5">شروع کنید</a>
            </div>
        </div>
        <div class="about-img">
            <img src="images/about-img.png" alt="">
        </div>
    </div>
</section>
<!-- About section end -->


<!-- Fact section -->
<section class="fact-section gradient-bg">
    <div class="container">
        <div class="row">
            <div class="col-sm-6 col-md-6 col-lg-3">
                <div class="fact">
                    <i class="ti-basketball"></i>
                    <h2>60+<span>تماس</span></h2>
                    <p>پشتیبانی کشورها</p>

                </div>
            </div>
            <div class="col-sm-6 col-md-6 col-lg-3">
                <div class="fact">
                    <i class="ti-panel"></i>
                    <h2>12+<span>هزار</span></h2>
                    <p>تراکنش‌ در هر ساعت</p>
                </div>
            </div>
            <div class="col-sm-6 col-md-6 col-lg-3">
                <div class="fact">
                    <i class="ti-stats-up"></i>
                    <h2>5<span>میلیارد</span></h2>
                    <p>بیشترین تراکنش‌ها</p>
                </div>
            </div>
            <div class="col-sm-6 col-md-6 col-lg-3">
                <div class="fact">
                    <i class="ti-user"></i>
                    <h2>211<span>پروژه</span></h2>
                    <p>میزان تجربه ما</p>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Fact section end -->


<!-- Team section -->
<section class="team-section spad">
    <div class="container">
        <div class="section-title text-center">
            <h2>متخصصان تیم ما</h2>
            <p>متخصصان و کارشناسان ما آماده‌اند تا با روی باز به سوالات مربوط به ارزهای دیجیتال شما پاسخ دهند.</p>
        </div>
    </div>
    <div class="team-members clearfix">
        <!-- Team member -->
        <div class="member">
            <div class="member-text">
                <div class="member-img set-bg" data-setbg="img/member/1.jpg"></div>
                <h2>صابر افشاری</h2>
                <span>متخصص رمز ارزها</span>
            </div>
            <div class="member-social">
                <a href=""><i class="fa fa-facebook"></i></a>
                <a href=""><i class="fa fa-linkedin"></i></a>
                <a href=""><i class="fa fa-twitter"></i></a>
                <a href=""><i class="fa fa-paper-plane"></i></a>
                <a href=""><i class="fa fa-instagram"></i></a>

            </div>
            <div class="member-info">
                <div class="member-img mf set-bg" data-setbg="images/member/1.jpg"></div>
                <div class="member-meta">
                    <h2>صابر افشاری</h2>
                    <span>تحلیلگر فاندامنتال</span>
                </div>
                <p>لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.
                    چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است </p>
            </div>
        </div>
        <!-- Team member -->
        <div class="member">
            <div class="member-text">
                <div class="member-img set-bg" data-setbg="images/member/2.jpg"></div>
                <h2>صابر افشاری</h2>
                <span>متخصص رمز ارزها</span>
            </div>
            <div class="member-social">
                <a href=""><i class="fa fa-facebook"></i></a>
                <a href=""><i class="fa fa-linkedin"></i></a>
                <a href=""><i class="fa fa-twitter"></i></a>
                <a href=""><i class="fa fa-paper-plane"></i></a>
                <a href=""><i class="fa fa-instagram"></i></a>
            </div>
            <div class="member-info">
                <div class="member-img mf set-bg" data-setbg="images/member/2.jpg"></div>
                <div class="member-meta">
                    <h2>صابر افشاری</h2>
                    <span>تحلیلگر فاندامنتال</span>
                </div>
                <p>لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.
                    چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است </p>
            </div>
        </div>
        <!-- Team member -->
        <div class="member">
            <div class="member-text">
                <div class="member-img set-bg" data-setbg="images/member/3.jpg"></div>
                <h2>صابر افشاری</h2>
                <span>متخصص رمز ارزها</span>
            </div>
            <div class="member-social">
                <a href=""><i class="fa fa-facebook"></i></a>
                <a href=""><i class="fa fa-linkedin"></i></a>
                <a href=""><i class="fa fa-twitter"></i></a>
                <a href=""><i class="fa fa-paper-plane"></i></a>
                <a href=""><i class="fa fa-instagram"></i></a>
            </div>
            <div class="member-info">
                <div class="member-img mf set-bg" data-setbg="images/member/3.jpg"></div>
                <div class="member-meta">
                    <h2>صابر افشاری</h2>
                    <span>مدیرعامل و تحلیلگر</span>
                </div>
                <p>لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.
                    چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است </p>
            </div>
        </div>
        <!-- Team member -->
        <div class="member">
            <div class="member-text">
                <div class="member-img set-bg" data-setbg="images/member/4.jpg"></div>
                <h2>صابر افشاری</h2>
                <span>مدیر تبلیغات</span>
            </div>
            <div class="member-social">
                <a href=""><i class="fa fa-facebook"></i></a>
                <a href=""><i class="fa fa-linkedin"></i></a>
                <a href=""><i class="fa fa-twitter"></i></a>
                <a href=""><i class="fa fa-paper-plane"></i></a>
                <a href=""><i class="fa fa-instagram"></i></a>
            </div>
            <div class="member-info">
                <div class="member-img mf set-bg" data-setbg="images/member/4.jpg"></div>
                <div class="member-meta">
                    <h2>صابر افشاری</h2>
                    <span>مدیر تبلیغات</span>
                </div>
                <p>لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.
                    چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است </p>
            </div>
        </div>
        <!-- Team member -->
        <div class="member">
            <div class="member-text">
                <div class="member-img set-bg" data-setbg="images/member/5.jpg"></div>
                <h2>صابر افشاری</h2>
                <span>کارشناس امنیت</span>
            </div>
            <div class="member-social">
                <a href=""><i class="fa fa-facebook"></i></a>
                <a href=""><i class="fa fa-linkedin"></i></a>
                <a href=""><i class="fa fa-twitter"></i></a>
                <a href=""><i class="fa fa-paper-plane"></i></a>
                <a href=""><i class="fa fa-instagram"></i></a>
            </div>
            <div class="member-info">
                <div class="member-img mf set-bg" data-setbg="images/member/5.jpg"></div>
                <div class="member-meta">
                    <h2>صابر افشاری</h2>
                    <span>کارشناس امنیت</span>
                </div>
                <p>لورم ایپسوم متن ساختگی با تولید سادگی نامفهوم از صنعت چاپ و با استفاده از طراحان گرافیک است.
                    چاپگرها و متون بلکه روزنامه و مجله در ستون و سطرآنچنان که لازم است </p>
            </div>
        </div>
    </div>
</section>
<!-- Team section -->


<!-- Review section -->
<section class="review-section spad">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 push-8">
                <img src="images/quote.png" alt="" class="quote mb-5">
                <div class="review-text-slider owl-carousel">
                    <div class="review-text">
                        <p>"به طور خلاصه هدف پیدایش بیت کوین انتقال و یا ذخیره امن پول است. از همین جهت آن را
                            می‌توان یک سیستم پرداخت و بانکداری دیجیتال امن دانست.”</p>
                    </div>
                    <div class="review-text">
                        <p>"به طور خلاصه هدف پیدایش بیت کوین انتقال و یا ذخیره امن پول است. از همین جهت آن را
                            می‌توان یک سیستم پرداخت و بانکداری دیجیتال امن دانست.”</p>
                    </div>
                    <div class="review-text">
                        <p>"به طور خلاصه هدف پیدایش بیت کوین انتقال و یا ذخیره امن پول است. از همین جهت آن را
                            می‌توان یک سیستم پرداخت و بانکداری دیجیتال امن دانست.”</p>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 pr-0 pull-3">
                <div class="review-meta-slider owl-carousel pt-5">
                    <div class="author-meta">
                        <div class="author-avatar set-bg" data-setbg="images/review/1.jpg"></div>
                        <div class="author-name">
                            <h4>صابر افشاری</h4>
                            <p>مدیرعامل و تحلیلگر</p>
                        </div>
                    </div>
                    <div class="author-meta">
                        <div class="author-avatar set-bg" data-setbg="images/review/2.jpg"></div>
                        <div class="author-name">
                            <h4>صابر افشاری</h4>
                            <p>کارشناس امنیت</p>
                        </div>
                    </div>
                    <div class="author-meta">
                        <div class="author-avatar set-bg" data-setbg="images/review/3.jpg"></div>
                        <div class="author-name">
                            <h4>صابر افشاری</h4>
                            <p>مدیر تبلیغات</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Review section end -->


<!-- Newsletter section -->
<section class="newsletter-section gradient-bg">
    <div class="container text-white">
        <div class="row">
            <div class="col-lg-7 newsletter-text">
                <h2>مشترک خبرنامه کریپتو پلاس شوید</h2>
                <p>با عضویت در خبرنامه زودتر از بقیه از اخبار بازار رمز ارزها مطلع شوید.</p>
            </div>
            <div class="col-lg-5 col-md-8 offset-lg-0 offset-md-2">
                <form class="newsletter-form">
                    <input type="text" placeholder="ایمیل خود را وارد کنید">
                    <button>عضویت</button>
                </form>
            </div>
        </div>
    </div>
</section>
<!-- Newsletter section end -->


<!-- Footer section -->
<?php
include  'include/footer.php';
?>
<!-- Footer section end -->

<!--====== Javascripts & Jquery ======-->
<script src="js/jquery-3.2.1.min.js"></script>
<script src="js/owl.carousel.min.js"></script>
<script src="js/main.js"></script>
</body>

</html>