<?php

include 'include/config.php';

error_reporting(E_ALL);
ini_set('display_errors', 1);

?>

<!DOCTYPE html>
<html lang="en">

<head>
    <title>بیمه بدنه</title>
    <meta charset="UTF-8">
    <meta name="description" content="Cryptoplus Landing Page Template">
    <meta name="keywords" content="cryptoplus, crypto, creative, html, landing_page">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- Favicon -->
    <link href="images/favicon.ico" rel="shortcut icon" />

    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css?family=Lato" rel="stylesheet">

    <!-- Stylesheets -->
    <link rel="stylesheet" href="css/bootstrap.min.css" />
    <link rel="stylesheet" href="css/font-awesome.min.css" />
    <link rel="stylesheet" href="css/fontiran.css" />
    <link rel="stylesheet" href="css/themify-icons.css" />
    <link rel="stylesheet" href="css/animate.css" />
    <link rel="stylesheet" href="css/owl.carousel.css" />
    <link rel="stylesheet" href="css/style.css" />


    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->


    <style>
        .hidden {
            display: none;
        }
        .step {
            display: none;
        }
        .step.active {
            display: block;
        }
        .buttons {
            margin-top: 20px;
        }

        /* The Modal (background) */
        .modal {
            display: none; /* Hidden by default */
            position: fixed; /* Stay in place */
            z-index: 1; /* Sit on top */
            left: 0;
            top: 0;
            width: 100%; /* Full width */
            height: 100%; /* Full height */
            overflow: auto; /* Enable scroll if needed */
            background-color: rgb(0,0,0); /* Fallback color */
            background-color: rgba(0,0,0,0.4); /* Black w/ opacity */
            padding-top: 60px;
        }

        /* Modal Content/Box */
        .modal-content {
            background-color: #fefefe;
            margin: 5% auto; /* 15% from the top and centered */
            padding: 20px;
            border: 1px solid #888;
            width: 80%; /* Could be more or less, depending on screen size */
            max-width: 400px;
        }

        /* The Close Button */
        .close {
            color: #aaa;
            float: right;
            font-size: 28px;
            font-weight: bold;
        }

        .close:hover,
        .close:focus {
            color: black;
            text-decoration: none;
            cursor: pointer;
        }


    </style>

</head>

<body>
<!-- Page Preloder -->
<div id="preloder">
    <div class="loader"></div>
</div>

<!-- Header section -->
<?php

include 'include/header.php';

?>
<!-- Header section end -->



<!-- Page info section -->
<section class="page-info-section">
    <div class="container">
        <h2>بیمه بدنه</h2>
        <div class="site-beradcamb">
            <a href="index.php">صفحه نخست</a>
            <i class="fa fa-angle-right"></i>
            <span><i class="fa fa-angle-right"></i>بیمه بدنه</span>
        </div>
    </div>
</section>
<!-- Page info end -->



<!-- Process section -->
<section class="process-section spad">
    <div class="container">

        <div class="section-title text-center">
            <h2>بیمه بدنه</h2>
            <p>با خرید بیمه بدنه می توانید اتومبیل خود را در مقابل خطرات تصادف،آتش سوزی،سرقت و پوشش های اضافی از جمله سرقت لوازم،شکست شیشه،بلایای طبیعی و ... تحت پوشش بیمه قرار دهید</p>
        </div>

       <div class="row">
           <h4>وارد کردن اطلاعات</h4>
       </div>
        <br>



        <div class="row">




            <form id="multiStepForm">
                <!-- Step 1 -->
                <div class="step active">



                  <div class="row">

                      <div class="form-group">
                          <label for="type">انتخاب برند خودرو</label>

                          <div class="form-group">

                              <select name="company_brand_select" id="company_brand_select" class="form-control form-select select2" required>
                                  <option value="" disabled selected>انتخاب کنید</option>
                                  <?php

                                  $sql = "SELECT * FROM tbl_company_brand";

                                  $rs_result = mysqli_query($db, $sql);

                                  while  ($row = mysqli_fetch_array($rs_result)) {

                                      ?>

                                      <option value="<?= $row['id'];  ?>"><?= $row['name'] ?></option>
                                      <?php

                                  }

                                  ?>

                              </select>
                          </div>




                      </div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                      <div class="form-group">
                          <label for="type">انتخاب خودرو</label>

                          <div class="form-group">

                              <select name="car_select" id="car_select" class="form-control form-select select2" required>

                                  ?>

                              </select>
                          </div>




                      </div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                      <div class="form-group">
                          <label for="type">مورد استفاده</label>

                          <div class="form-group">

                              <select name="usage_select" id="usage_select" class="form-control form-select select2" required>

                                  ?>

                              </select>
                          </div>

                  </div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                      <div class="form-group">
                          <label for="type">سال ساخت خودرو</label>

                          <div class="form-group">

                              <select name="car_year" id="car_year" class="form-control form-select select2" required>
                                  <option value="" disabled selected>انتخاب کنید</option>
                                  <?php

                                  $sql = "SELECT * FROM tbl_car_year";

                                  $rs_result = mysqli_query($db, $sql);

                                  while  ($row = mysqli_fetch_array($rs_result)) {

                                      ?>

                                      <option value="<?= $row['id'];  ?>"><?php echo $row['persian']."-".$row['gregorian']; ?></option>
                                      <?php

                                  }

                                  ?>

                              </select>
                          </div>




                      </div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                      <div class="form-group">

                          <label for="vehicle1">آیا خودرو دارای یدک می باشد؟</label><br>
                          <select id="aidOption" name="aidOption"  class="form-control form-select" required>
                              <option value="" disabled selected>انتخاب کنید</option>
                              <option value="0">خیر</option>
                              <option value="1">بله</option>
                          </select>
                      </div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                      <div class="form-group">
                          <label for="type"> نوع خودرو</label>

                          <div class="form-group">

                              <select name="car_type_select" id="car_type_select" class="form-control form-select select2" required>
                                  <option value="" disabled selected>انتخاب کنید</option>
                                  <?php

                                  $sql = "SELECT * FROM tbl_car_type";

                                  $rs_result = mysqli_query($db, $sql);

                                  while  ($row = mysqli_fetch_array($rs_result)) {

                                      ?>

                                      <option value="<?= $row['id'];  ?>"><?= $row['name'] ?></option>
                                      <?php

                                  }

                                  ?>

                              </select>
                          </div>




                      </div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                </div>

                    <div class="buttons">
                        <button type="button" id="next1">بعدی</button>
                    </div>

                </div>

                <!-- Step 2 -->
                <div class="step">

                    <div class="row">

                        <div class="form-group">
                            <label for="type">ارزش روز خودرو(به تومان)</label>

                            <div class="form-group">

                             <input type="text" id="car_value" name="car_value" required >
                            </div>




                        </div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        <div class="form-group">
                            <label for="type">ارزش لوازم اضافه خودرو(به تومان)</label>

                            <div class="form-group">

                                <input type="text" id="car_value_things" name="car_value_things" required >
                            </div>




                        </div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

                    </div>
                    <div class="buttons">
                        <button type="button" id="back2">برگشت</button>
                        <button type="button" id="next2">بعدی</button>
                    </div>
                </div>

                <!-- Step 3 -->
                <div class="step">

                    <div class="row">

                        <div class="form-group">

                            <label for="vehicle1">آیا خودرو  بیمه بدنه قبلی دارد؟</label><br>
                            <select id="insurance_before" name="insurance_before"  class="form-control form-select" required>
                                <option value="" disabled selected>انتخاب کنید</option>
                                <option value="0">خیر</option>
                                <option value="1">بله</option>
                            </select>
                        </div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        <div class="form-group">
                            <label for="type">درصد تخفیف بیمه ثالث</label>

                            <div class="form-group">

                                <input type="text" id="discount_insurance" name="discount_insurance" required >
                            </div>




                        </div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        <div class="form-group">
                            <label for="type">نام شرکت بیمه گر شخص ثالت</label>

                            <div class="form-group">

                                <select name="insurance_brand" id="insurance_brand" class="form-control form-select select2" required>


                                    <option value="" disabled selected>انتخاب کنید</option>

                                    <?php

                                    $sql = "SELECT * FROM tbl_insurance_companies where state=1";

                                    $rs_result = mysqli_query($db, $sql);

                                    while  ($row = mysqli_fetch_array($rs_result)) {

                                        ?>

                                        <option value="<?= $row['id'];  ?>"><?= $row['name'] ?></option>
                                        <?php

                                    }

                                    ?>

                                </select>
                            </div>




                        </div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        <div class="form-group">

                            <label for="vehicle1">آیا خودرو  صفر کیلومتر است؟</label><br>
                            <select id="insurance_before" name="insurance_before"  class="form-control form-select" required>
                                <option value="" disabled selected>انتخاب کنید</option>
                                <option value="0">خیر</option>
                                <option value="1">بله</option>
                            </select>
                        </div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;


                    </div>


                    <div class="buttons">
                        <button type="button" id="back3">برگشت</button>
                        <button type="button" id="next3">بعدی</button>
                    </div>
                </div>


                <!-- Step 4 -->
                <div class="step">

                    <div class="row">

                        <div class="form-group">

                            <label for="vehicle1">عدم خسارت خطرات اصلی</label><br>
                            <select id="damage_year" name="damage_year"  class="form-control form-select" required>
                                <option value="" disabled selected>انتخاب کنید</option>
                                <option value="1">یک سال عدم خسارت</option>
                                <option value="2">دو سال عدم خسارت</option>
                                <option value="3">سه سال عدم خسارت</option>
                            </select>
                        </div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        <div class="form-group">

                            <label for="vehicle1">عدم خسارت خطرات اضافی</label><br>
                            <select id="damage_year_extra" name="damage_year_extra"  class="form-control form-select" required>
                                <option value="" disabled selected>انتخاب کنید</option>
                                <option value="1">یک سال عدم خسارت</option>
                                <option value="2">دو سال عدم خسارت</option>
                                <option value="3">سه سال عدم خسارت</option>
                            </select>
                        </div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        <div class="form-group">
                            <label for="type">درصد تخفیف بیمه ثالث</label>

                            <div class="form-group">

                                <input type="text" id="discount_insurance" name="discount_insurance" required >
                            </div>




                        </div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        <div class="form-group">
                            <label for="type">نام شرکت بیمه گر شخص ثالت</label>

                            <div class="form-group">

                                <select name="insurance_brand" id="insurance_brand" class="form-control form-select select2" required>


                                    <option value="" disabled selected>انتخاب کنید</option>

                                    <?php

                                    $sql = "SELECT * FROM tbl_insurance_companies where state=1";

                                    $rs_result = mysqli_query($db, $sql);

                                    while  ($row = mysqli_fetch_array($rs_result)) {

                                        ?>

                                        <option value="<?= $row['id'];  ?>"><?= $row['name'] ?></option>
                                        <?php

                                    }

                                    ?>

                                </select>
                            </div>




                        </div>



                    </div>


                    <div class="buttons">
                        <button type="button" id="back3">برگشت</button>
                        <button type="button" id="next3">بعدی</button>
                    </div>
                </div>

                <!-- Step 5 -->
                <div class="step">

                    <div class="row">

                        <div class="form-group">

                            <label for="vehicle1">پوشش های تکمیلی</label><br>
                            <select id="damage_year" name="damage_year"  class="form-control form-select" required>
                                <option value="" disabled selected>انتخاب کنید</option>
                                <option value="1">یک سال عدم خسارت</option>
                                <option value="2">دو سال عدم خسارت</option>
                                <option value="3">سه سال عدم خسارت</option>
                            </select>
                        </div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        <div class="form-group">

                            <label for="vehicle1">پوشش سرقت درجای قطعات</label><br>
                            <select id="damage_year_extra" name="damage_year_extra"  class="form-control form-select" required>
                                <option value="" disabled selected>انتخاب کنید</option>
                                <option value="1">حداکثر تا 20 درصد ارزش خودرو</option>
                                <option value="2">حداکثر تا 10 درصد ارزش خودرو</option>
                                <option value="3">حداکثر تا 5 درصد ارزش خودرو</option>
                            </select>
                        </div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        <div class="form-group">
                            <label for="type">پوشش نوسانات قیمت خودرو</label>

                            <div class="form-group">

                                <select id="damage_year" name="damage_year"  class="form-control form-select" required>
                                    <option value="" disabled selected>انتخاب کنید</option>
                                    <option value="1">25 درصد ارزش خودرو</option>
                                    <option value="2">35 درصد ارزش خودرو</option>
                                    <option value="3">40 درصد ارزش خودرو</option>
                                </select>
                            </div>




                        </div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        <div class="form-group">
                            <label for="type">نوع پلاک خودرو</label>

                            <div class="form-group">
                                <select id="damage_year" name="damage_year"  class="form-control form-select" required>
                                    <option value="" disabled selected>انتخاب کنید</option>
                                    <option value="1">پلاک ملی</option>
                                    <option value="2">پلاک دولتی</option>
                                    <option value="3">پلاک دیپلوماتیک</option>
                                </select>
                            </div>




                        </div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;



                    </div>


                    <div class="buttons">
                        <button id="myBtn">Login</button>
                        <button type="button" id="back3">برگشت</button>
                        <button type="submit" id="next3">ثبت اطلاعات</button>
                    </div>
                </div>


            </form>



        </div>

    </div>
</section>
<!-- Process section end -->





<!-- Newsletter section -->
<?php
include 'include/newsletter.php';
?>
<!-- Newsletter section end -->


<!-- Footer section -->
<?php
include  'include/footer.php';
?>
<!-- Footer section end -->


<!-- The Modal -->
<div id="myModal" class="modal">

    <!-- Modal content -->
    <div class="modal-content">
        <span class="close">&times;</span>
        <h2>ورود به توانا</h2>
        <form>
            <label for="uname">شماره موبایل</label>
            <input type="text" id="uname" name="uname" required><br><br>
            <label for="psw">رمز عبور</label>
            <input type="password" id="psw" name="psw" required><br><br>
            <button type="submit">ورود</button>
            <button type="submit">عضویت</button>
        </form>
    </div>

</div>



<!--====== Javascripts & Jquery ======-->
<script src="js/jquery-3.2.1.min.js"></script>
<script src="js/owl.carousel.min.js"></script>
<script src="js/main.js"></script>



<!-- load for map -->
<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyB0YyDTa0qqOjIerob2VTIwo_XVMhrruxo"></script>
<script src="js/map.js"></script>



<script>

    $(document).ready(function() {
        // Function to fetch users based on the selected user type
        function fetchUsers(selectedOption) {
            $.ajax({
                url: 'database/fetch_cars.php',
                type: 'POST',
                dataType: 'json',
                data: { company_brand_select: selectedOption },
                success: function(users) {
                    // Clear the existing options in the second select
                    $('#car_select').empty();

                    // Loop through the users and create new options for the second select
                    users.forEach(function(user) {
                        var option = $('<option>').val(user.id).text(user.name);
                        $('#car_select').append(option);
                    });
                },
                error: function() {
                    console.log('Error occurred while fetching users.');
                }
            });
        }

        // Set the default selected option when the page loads
        var defaultSelectedOption = $('#company_brand_select').val();
        fetchUsers(defaultSelectedOption);

        // Listen for the change event on user_type_select
        $('#company_brand_select').change(function() {
            var selectedOption = $(this).children('option:selected').val();
            fetchUsers(selectedOption);
        });
    });


</script>


<script>

    $(document).ready(function() {
        // Function to fetch users based on the selected user type
        function fetchUsers(selectedOption) {
            $.ajax({
                url: 'database/fetch_car_usages.php',
                type: 'POST',
                dataType: 'json',
                data: { car_select: selectedOption },
                success: function(users) {
                    // Clear the existing options in the second select
                    $('#usage_select').empty();
                   // var option = $('<option>').val("").text("انتخاب کنید").disable();
                  //  $('#usage_select').append();

                    // Loop through the users and create new options for the second select
                    users.forEach(function(user) {
                        var option = $('<option>').val(user.id).text(user.name);
                        $('#usage_select').append(option);
                    });
                },
                error: function() {
                    console.log('Error occurred while fetching users.');
                }
            });
        }

        // Set the default selected option when the page loads
        var defaultSelectedOption = $('#car_select').val();
        fetchUsers(defaultSelectedOption);

        // Listen for the change event on user_type_select
        $('#car_select').change(function() {
            var selectedOption = $(this).children('option:selected').val();
            fetchUsers(selectedOption);
        });
    });


</script>


<script>
    document.getElementById('aidOption').addEventListener('change', function() {
        const additionalSelectContainer = document.getElementById('additionalSelectContainer');
        const additionalSelectContainerInsuranceNewCar = document.getElementById('additionalSelectContainerInsuranceNewCar');
        if (this.value === '0' || this.value === '1') {
            additionalSelectContainer.classList.remove('hidden');
        } else {
            additionalSelectContainer.classList.add('hidden');
            additionalSelectContainerInsuranceNewCar.classList.add('hidden');
        }
    });
</script>



<script>
    document.getElementById('insurance_brand').addEventListener('change', function() {
        const additionalSelectContainer = document.getElementById('additionalSelectContainerInsuranceNone');
        const additionalSelectContainerInsuranceNewCar = document.getElementById('additionalSelectContainerInsuranceNewCar');
        const additionalSelectContainerInsuranceStartingInsurance = document.getElementById('additionalSelectContainerInsuranceStartingInsurance');
        if (this.value === '1' ) {
            additionalSelectContainer.classList.remove('hidden');
            additionalSelectContainerInsuranceNewCar.classList.add('hidden');
            additionalSelectContainerInsuranceStartingInsurance.classList.add('hidden');
        }else if(this.value == '2') {
            additionalSelectContainerInsuranceStartingInsurance.classList.add('hidden');
            additionalSelectContainer.classList.add('hidden');
            additionalSelectContainerInsuranceNewCar.classList.remove('hidden');
        } else {
            additionalSelectContainerInsuranceStartingInsurance.classList.remove('hidden');
            additionalSelectContainer.classList.add('hidden');
            additionalSelectContainerInsuranceNewCar.classList.add('hidden');
        }
    });
</script>




<script>
    document.getElementById('continueButton').addEventListener('click', function() {
        document.getElementById('additionalSelectContainerInsuranceNewCar').classList.remove('hidden');
    });
</script>


<script>
    document.getElementById('continueButtonStartNumbering').addEventListener('click', function() {
        document.getElementById('additionalSelectContainerInsuranceNone').classList.remove('hidden');
    });
</script>


<script>
    const steps = document.querySelectorAll('.step');
    const nextButtons = document.querySelectorAll('[id^=next]');
    const backButtons = document.querySelectorAll('[id^=back]');
    let currentStep = 0;

    nextButtons.forEach(button => {
        button.addEventListener('click', () => {
            if (validateForm()) {
                steps[currentStep].classList.remove('active');
                currentStep++;
                steps[currentStep].classList.add('active');
            }
        });
    });

    backButtons.forEach(button => {
        button.addEventListener('click', () => {
            steps[currentStep].classList.remove('active');
            currentStep--;
            steps[currentStep].classList.add('active');
        });
    });

    function validateForm() {
        const inputs = steps[currentStep].querySelectorAll('select');
        for (let i = 0; i < inputs.length; i++) {
            if (!inputs[i].value) {
                alert('تمامی موارد می بایست کامل شوند');
                return false;
            }
        }

        const inputs2 = steps[currentStep].querySelectorAll('input');
        for (let i = 0; i < inputs2.length; i++) {
            if (!inputs2[i].value) {
                alert('تمامی موارد می بایست کامل شوند');
                return false;
            }
        }


        return true;
    }
</script>


<script>
    // Get the modal
    var modal = document.getElementById("myModal");

    // Get the button that opens the modal
    var btn = document.getElementById("myBtn");

    // Get the <span> element that closes the modal
    var span = document.getElementsByClassName("close")[0];

    // When the user clicks the button, open the modal
    btn.onclick = function() {
        modal.style.display = "block";
    }

    // When the user clicks on <span> (x), close the modal
    span.onclick = function() {
        modal.style.display = "none";
    }

    // When the user clicks anywhere outside of the modal, close it
    window.onclick = function(event) {
        if (event.target == modal) {
            modal.style.display = "none";
        }
    }
</script>



</body>

</html>