<?php

include 'include/config.php';

error_reporting(E_ALL);
ini_set('display_errors', 1);

?>

<!DOCTYPE html>
<html lang="en">

<head>
    <title>شخص ثالث خودرو</title>
    <meta charset="UTF-8">
    <meta name="description" content="Cryptoplus Landing Page Template">
    <meta name="keywords" content="cryptoplus, crypto, creative, html, landing_page">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- Favicon -->
    <link href="images/favicon.ico" rel="shortcut icon" />

    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css?family=Lato" rel="stylesheet">

    <!-- Stylesheets -->
    <link rel="stylesheet" href="css/bootstrap.min.css" />
    <link rel="stylesheet" href="css/font-awesome.min.css" />
    <link rel="stylesheet" href="css/fontiran.css" />
    <link rel="stylesheet" href="css/themify-icons.css" />
    <link rel="stylesheet" href="css/animate.css" />
    <link rel="stylesheet" href="css/owl.carousel.css" />
    <link rel="stylesheet" href="css/style.css" />


    <!--[if lt IE 9]>
    <script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
    <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->


    <style>
        .hidden {
            display: none;
        }
        .step {
            display: none;
        }
        .step.active {
            display: block;
        }
        .buttons {
            margin-top: 20px;
        }

        /* The Modal (background) */
        .modal {
            display: none; /* Hidden by default */
            position: fixed; /* Stay in place */
            z-index: 1; /* Sit on top */
            left: 0;
            top: 0;
            width: 100%; /* Full width */
            height: 100%; /* Full height */
            overflow: auto; /* Enable scroll if needed */
            background-color: rgb(0,0,0); /* Fallback color */
            background-color: rgba(0,0,0,0.4); /* Black w/ opacity */
            padding-top: 60px;
        }

        /* Modal Content/Box */
        .modal-content {
            background-color: #fefefe;
            margin: 5% auto; /* 15% from the top and centered */
            padding: 20px;
            border: 1px solid #888;
            width: 80%; /* Could be more or less, depending on screen size */
            max-width: 400px;
        }

        /* The Close Button */
        .close {
            color: #aaa;
            float: right;
            font-size: 28px;
            font-weight: bold;
        }

        .close:hover,
        .close:focus {
            color: black;
            text-decoration: none;
            cursor: pointer;
        }


    </style>

</head>

<body>
<!-- Page Preloder -->
<div id="preloder">
    <div class="loader"></div>
</div>

<!-- Header section -->
<?php

include 'include/header.php';

?>
<!-- Header section end -->



<!-- Page info section -->
<section class="page-info-section">
    <div class="container">
        <h2>بیمه شخص ثالث خودرو</h2>
        <div class="site-beradcamb">
            <a href="index.php">صفحه نخست</a>
            <i class="fa fa-angle-right"></i>
            <a href="third_party_insurance.php">بیمه شخص ثالث</a>
            <span><i class="fa fa-angle-right"></i>  بیمه  ثالث خودرو</span>
        </div>
    </div>
</section>
<!-- Page info end -->



<!-- Process section -->
<section class="process-section spad">
    <div class="container">

        <div class="section-title text-center">
            <h2>بیمه شخص ثالث خودرو</h2>
            <p>بیمه شخص ثالث اتومبیل، خسارتهای جانی و مالی وارده به اشخاص ثالث ناشی از حوادث رانندگی را جبران می نماید.</p>
        </div>

        <div class="row">




            <form id="multiStepForm">
                <!-- Step 1 -->
                <div class="step active" id="step1">

                    <div class="row">

                        <div class="form-group">
                            <label for="type">انتخاب برند خودرو</label>

                            <div class="form-group">

                                <select name="company_brand_select" id="company_brand_select" class="form-control form-select select2" required>
                                    <option value="" disabled selected>انتخاب کنید</option>
                                    <?php

                                    $sql = "SELECT * FROM tbl_company_brand";

                                    $rs_result = mysqli_query($db, $sql);

                                    while  ($row = mysqli_fetch_array($rs_result)) {

                                        ?>

                                        <option value="<?= $row['id'];  ?>"><?= $row['name'] ?></option>
                                        <?php

                                    }

                                    ?>

                                </select>
                            </div>




                        </div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        <div class="form-group">
                            <label for="type">انتخاب خودرو</label>

                            <div class="form-group">

                                <select name="car_select" id="car_select" class="form-control form-select select2" required>

                                    ?>

                                </select>
                            </div>




                        </div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        <div class="form-group">
                            <label for="type">مورد استفاده</label>

                            <div class="form-group">

                                <select name="usage_select" id="usage_select" class="form-control form-select select2" required>

                                    ?>

                                </select>
                            </div>

                        </div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        <div class="form-group">
                            <label for="type">سال ساخت خودرو</label>

                            <div class="form-group">

                                <select name="car_year" id="car_year" class="form-control form-select select2" required>
                                    <option value="" disabled selected>انتخاب کنید</option>
                                    <?php

                                    $sql = "SELECT * FROM tbl_car_year";

                                    $rs_result = mysqli_query($db, $sql);

                                    while  ($row = mysqli_fetch_array($rs_result)) {

                                        ?>

                                        <option value="<?= $row['id'];  ?>"><?php echo $row['persian']."-".$row['gregorian']; ?></option>
                                        <?php

                                    }

                                    ?>

                                </select>
                            </div>




                        </div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;
                        <div class="form-group">

                            <label for="vehicle1">آیا خودرو دارای یدک می باشد؟</label><br>
                            <select id="aidOption" name="aidOption"  class="form-control form-select" required>
                                <option value="" disabled selected>انتخاب کنید</option>
                                <option value="0">خیر</option>
                                <option value="1">بله</option>
                            </select>
                        </div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

                    </div>




                    <div class="buttons">
                        <button type="button" class="next" data-next="step2">بعدی</button>
                    </div>
                </div>

                <!-- Step 2 -->
                <div class="step" id="step2">

                    <div class="row">

                        <div class="form-group">
                            <label for="type">شرکت بیمه قبلی خود را انتخاب کنید</label>

                            <div class="form-group">

                                <select name="insurance_brand" id="insurance_brand" class="form-control form-select select2" required>


                                    <option value="" disabled selected>انتخاب کنید</option>

                                    <?php

                                    $sql = "SELECT * FROM tbl_insurance_companies";

                                    $rs_result = mysqli_query($db, $sql);

                                    while  ($row = mysqli_fetch_array($rs_result)) {

                                        ?>

                                        <option value="<?= $row['id'];  ?>"><?= $row['name'] ?></option>
                                        <?php

                                    }

                                    ?>

                                </select>
                            </div>




                        </div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

                    </div>

                    <div class="buttons">
                        <button type="button" class="back" data-back="step1">برگشت</button>
                        <button type="button" class="next" data-next="step3">بعدی</button>
                    </div>
                </div>

                <!-- Step 3 -->
                <!-- faghed bime -->
                <div class="step" id="step3">

                    <div class="row">

                        <div class="form-group">
                            <label for="type">پوشش حواث فوت راننده(مقصر)</label>

                            <div class="form-group">

                                <select name="insurance_brand2" id="insurance_brand2" class="form-control form-select select2" required>

                                    <option value="" disabled selected>انتخاب کنید</option>
                                    <option value="0">1 میلیارد و 200 میلیون تومان</option>
                                    <option value="1">1 میلیارد و 600 میلیون تومان</option>

                                </select>
                            </div>




                        </div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

                        <div class="form-group">
                            <label for="type">پوشش خسارت مالی در قبال اشخاص ثالث</label>

                            <div class="form-group">

                                <select name="insurance_brand2" id="insurance_brand2" class="form-control form-select select2" required>

                                    <option value="" disabled selected>انتخاب کنید</option>
                                    <option value="0">40 میلیون تومان</option>
                                    <option value="1">50 میلیون تومان</option>
                                    <option value="2">80 میلیون تومان</option>
                                    <option value="3">100 میلیون تومان</option>
                                    <option value="4">120 میلیون تومان</option>
                                    <option value="5">200 میلیون تومان</option>
                                    <option value="6">250 میلیون تومان</option>
                                    <option value="7">300 میلیون تومان</option>
                                    <option value="8">400 میلیون تومان</option>
                                    <option value="9">500 میلیون تومان</option>
                                    <option value="10">600 میلیون تومان</option>
                                    <option value="11">700 میلیون تومان</option>
                                    <option value="12">800 میلیون تومان</option>

                                </select>
                            </div>




                        </div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

                        <div class="form-group">
                            <label for="type">مدت بیمه نامه</label>

                            <div class="form-group">

                                <select name="insurance_brand2" id="insurance_brand2" class="form-control form-select select2" required>

                                    <option value="" disabled selected>انتخاب کنید</option>
                                    <option value="0">یکساله</option>
                                    <option value="1">شش ماهه</option>
                                    <option value="1">چهار ماهه</option>
                                    <option value="3">سه ماهه</option>
                                    <option value="4">دو ماهه</option>


                                </select>
                            </div>




                        </div>


                    </div>


                    <div class="buttons">
                        <button type="button" class="back" data-back="step2">برگشت</button>
                        <button type="button" class="next" data-next="step6">محاسبه</button>
                    </div>
                </div>

                <!-- Step 4 -->
                <div class="step" id="step4">
                    <div>

                        <div class="form-group">
                            <label for="type">تاریخ شماره گذاری / ورود از گمرک</label>

                            <div class="form-group">

                                <input id="startDate" class="form-control" type="date" />

                            </div>




                        </div>

                    </div>
                    <div class="buttons">
                        <button type="button" class="back" data-back="step3">برگشت</button>
                        <button type="button" class="next" data-next="step3">بعدی</button>
                    </div>
                </div>



                <!-- Step 5 -->
                <div class="step" id="step5">

                    <div class="row">

                        <div class="form-group">
                            <label for="type">تاریخ شروع بیمه‌نامه سال قبل</label>

                            <div class="form-group">

                                <input id="startDateInsurance" class="form-control" type="date" />

                            </div>




                        </div>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;

                        <div class="form-group">
                            <label for="type">تاریخ پایان بیمه‌نامه سال قبل</label>

                            <div class="form-group">

                                <input id="endDateInsurance" class="form-control" type="date" />

                            </div>




                        </div>

                    </div>


                    <div class="buttons">
                        <button type="button" class="back" data-back="step4">برگشت</button>
                        <button type="button" class="next" data-next="step6">بعدی</button>
                    </div>
                </div>


                <!-- Step 6 -->
                <div class="step" id="step6">

                    <div class="row">

                        <div class="form-group">

                            <label for="change_pelak">آیا این وسیله نقلیه در مدت بیمه نامه قبلی تعویض پلاک داشته است؟</label><br>
                            <select id="change_pelak" name="change_pelak"  class="form-control form-select" required>
                                <option value="" disabled selected>انتخاب کنید</option>
                                <option value="0">خیر،تعویض پلاک نداشته است</option>
                                <option value="1">بله،پلاک وسیله نقلیه تعویض شده است</option>
                            </select>
                        </div>

                    </div>


                    <div class="buttons">
                        <button type="button" class="back" data-back="step4">برگشت</button>
                        <button type="button" class="next" data-next="step3">بعدی</button>
                    </div>
                </div>



                <!-- Step 6 -->
                <div class="step" id="step7">
                    <h2>Step 6</h2>
                    <div class="buttons">
                        <button type="button" class="back" data-back="step4">برگشت</button>
                        <button type="submit">Submit</button>
                    </div>
                </div>
            </form>



        </div>




    </div>

    </div>
</section>
<!-- Process section end -->


<!-- Newsletter section -->
<?php
include 'include/newsletter.php';
?>
<!-- Newsletter section end -->


<!-- Footer section -->
<?php
include  'include/footer.php';
?>
<!-- Footer section end -->


<!--====== Javascripts & Jquery ======-->
<script src="js/jquery-3.2.1.min.js"></script>
<script src="js/owl.carousel.min.js"></script>
<script src="js/main.js"></script>



<!-- load for map -->
<script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyB0YyDTa0qqOjIerob2VTIwo_XVMhrruxo"></script>
<script src="js/map.js"></script>





<script>

    $(document).ready(function() {
        // Function to fetch users based on the selected user type
        function fetchUsers(selectedOption) {
            $.ajax({
                url: 'database/fetch_cars.php',
                type: 'POST',
                dataType: 'json',
                data: { company_brand_select: selectedOption },
                success: function(users) {
                    // Clear the existing options in the second select
                    $('#car_select').empty();

                    // Loop through the users and create new options for the second select
                    users.forEach(function(user) {
                        var option = $('<option>').val(user.id).text(user.name);
                        $('#car_select').append(option);
                    });
                },
                error: function() {
                    console.log('Error occurred while fetching users.');
                }
            });
        }

        // Set the default selected option when the page loads
        var defaultSelectedOption = $('#company_brand_select').val();
        fetchUsers(defaultSelectedOption);

        // Listen for the change event on user_type_select
        $('#company_brand_select').change(function() {
            var selectedOption = $(this).children('option:selected').val();
            fetchUsers(selectedOption);
        });
    });


</script>


<script>

    $(document).ready(function() {
        // Function to fetch users based on the selected user type
        function fetchUsers(selectedOption) {
            $.ajax({
                url: 'database/fetch_car_usages.php',
                type: 'POST',
                dataType: 'json',
                data: { car_select: selectedOption },
                success: function(users) {
                    // Clear the existing options in the second select
                    $('#usage_select').empty();
                    // var option = $('<option>').val("").text("انتخاب کنید").disable();
                    //  $('#usage_select').append();

                    // Loop through the users and create new options for the second select
                    users.forEach(function(user) {
                        var option = $('<option>').val(user.id).text(user.name);
                        $('#usage_select').append(option);
                    });
                },
                error: function() {
                    console.log('Error occurred while fetching users.');
                }
            });
        }

        // Set the default selected option when the page loads
        var defaultSelectedOption = $('#car_select').val();
        fetchUsers(defaultSelectedOption);

        // Listen for the change event on user_type_select
        $('#car_select').change(function() {
            var selectedOption = $(this).children('option:selected').val();
            fetchUsers(selectedOption);
        });
    });


</script>


<script>
    document.getElementById('aidOption').addEventListener('change', function() {
        const additionalSelectContainer = document.getElementById('additionalSelectContainer');
        const additionalSelectContainerInsuranceNewCar = document.getElementById('additionalSelectContainerInsuranceNewCar');
        if (this.value === '0' || this.value === '1') {
            additionalSelectContainer.classList.remove('hidden');
        } else {
            additionalSelectContainer.classList.add('hidden');
            additionalSelectContainerInsuranceNewCar.classList.add('hidden');
        }
    });
</script>



<script>
    document.getElementById('insurance_brand').addEventListener('change', function() {
        const additionalSelectContainer = document.getElementById('additionalSelectContainerInsuranceNone');
        const additionalSelectContainerInsuranceNewCar = document.getElementById('additionalSelectContainerInsuranceNewCar');
        const additionalSelectContainerInsuranceStartingInsurance = document.getElementById('additionalSelectContainerInsuranceStartingInsurance');
        if (this.value === '1' ) {
            additionalSelectContainer.classList.remove('hidden');
            additionalSelectContainerInsuranceNewCar.classList.add('hidden');
            additionalSelectContainerInsuranceStartingInsurance.classList.add('hidden');
        }else if(this.value == '2') {
            additionalSelectContainerInsuranceStartingInsurance.classList.add('hidden');
            additionalSelectContainer.classList.add('hidden');
            additionalSelectContainerInsuranceNewCar.classList.remove('hidden');
        } else {
            additionalSelectContainerInsuranceStartingInsurance.classList.remove('hidden');
            additionalSelectContainer.classList.add('hidden');
            additionalSelectContainerInsuranceNewCar.classList.add('hidden');
        }
    });
</script>




<script>
    document.getElementById('continueButton').addEventListener('click', function() {
        document.getElementById('additionalSelectContainerInsuranceNewCar').classList.remove('hidden');
    });
</script>


<script>
    document.getElementById('continueButtonStartNumbering').addEventListener('click', function() {
        document.getElementById('additionalSelectContainerInsuranceNone').classList.remove('hidden');
    });
</script>


<script>
    document.addEventListener('DOMContentLoaded', function() {
        const steps = document.querySelectorAll('.step');
        const buttons = document.querySelectorAll('button');
        const selectCarYear = document.getElementById('insurance_brand');

        buttons.forEach(button => {
            button.addEventListener('click', function() {
                const currentStep = document.querySelector('.step.active');
                const nextStepId = button.getAttribute('data-next');
                const backStepId = button.getAttribute('data-back');

                if (nextStepId) {
                    const nextStep = document.getElementById(nextStepId);
                    if (nextStep) {
                        currentStep.classList.remove('active');
                        nextStep.classList.add('active');
                    }
                }

                if (backStepId) {
                    const backStep = document.getElementById(backStepId);
                    if (backStep) {
                        currentStep.classList.remove('active');
                        backStep.classList.add('active');
                    }
                }
            });
        });

        selectCarYear.addEventListener('change', function() {
            const selectedValue = selectCarYear.value;
            if (selectedValue === "1") {
                goToStep('step3');
            } else if (selectedValue === "2") {
                goToStep('step4');
            } else {
                goToStep('step5');
            }
        });

        function goToStep(stepId) {
            const steps = document.querySelectorAll('.step');
            const targetStep = document.getElementById(stepId);

            if (targetStep) {
                steps.forEach(step => step.classList.remove('active'));
                targetStep.classList.add('active');
            }
        }
    });
</script>



</body>

</html>